<?php

namespace backend\models;

use Yii;
use backend\models\Jenjang;
use backend\models\Pendaftaran;
use backend\models\Prodi;

/**
 * This is the model class for table "fakultas".
 *
 * @property int $id
 * @property string $nama
 *
 * @property Jenjang[] $jenjangs
 * @property Pendaftaran[] $pendaftarans
 * @property Prodi[] $prodis
 */
class Fakultas extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'fakultas';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['nama'], 'required'],
            [['nama'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'nama' => 'Nama',
        ];
    }

    /**
     * Gets query for [[Jenjangs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getJenjangs()
    {
        return $this->hasMany(Jenjang::class, ['fakultas_id' => 'id']);
    }

    /**
     * Gets query for [[Pendaftarans]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPendaftarans()
    {
        return $this->hasMany(Pendaftaran::class, ['fakultas_id' => 'id']);
    }

    /**
     * Gets query for [[Prodis]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProdis()
    {
        return $this->hasMany(Prodi::class, ['fakultas_id' => 'id']);
    }
}
