<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "jenjang".
 *
 * @property int $id
 * @property int $fakultas_id
 * @property string $nama
 *
 * @property Fakultas $fakultas
 * @property Pendaftaran[] $pendaftarans
 * @property Prodi[] $prodis
 */
class Jenjang extends \yii\db\ActiveRecord
{


    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'jenjang';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['fakultas_id', 'nama'], 'required'],
            [['fakultas_id'], 'integer'],
            [['nama'], 'string', 'max' => 50],
            [['fakultas_id'], 'exist', 'skipOnError' => true, 'targetClass' => Fakultas::class, 'targetAttribute' => ['fakultas_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'fakultas_id' => 'Fakultas ID',
            'nama' => 'Nama',
        ];
    }

    /**
     * Gets query for [[Fakultas]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getFakultas()
    {
        return $this->hasOne(Fakultas::class, ['id' => 'fakultas_id']);
    }

    /**
     * Gets query for [[Pendaftarans]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPendaftarans()
    {
        return $this->hasMany(Pendaftaran::class, ['jenjang_id' => 'id']);
    }

    /**
     * Gets query for [[Prodis]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProdis()
    {
        return $this->hasMany(Prodi::class, ['jenjang_id' => 'id']);
    }
    

}
