<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "pendaftaran".
 *
 * @property int $id
 * @property string $email
 * @property string $judul_karya_ilmiah
 * @property string $nama_lengkap
 * @property string $nim
 * @property int $fakultas_id
 * @property int $jenjang_id
 * @property int $prodi_id
 * @property string $pembimbing_1
 * @property string|null $pembimbing_2
 * @property string $nomor_handphone
 * @property string $jenis_kelamin
 * @property string|null $nomor_inventaris
 * @property string|null $password
 * @property string|null $nidn1
 * @property string|null $nidn2
 * @property string|null $status
 * @property string|null $status_persetujuan
 * @property int|null $jumlah_revisi
 * @property string|null $file_path
 */
class Pendaftaran extends \yii\db\ActiveRecord
{
    /**
     * @var \yii\web\UploadedFile
     */
    public $fileUpload;

    public static function tableName()
    {
        return 'pendaftaran';
    }

    public function rules()
    {
        return [
            // rules lama (tetap dipertahankan)
            [['email', 'judul_karya_ilmiah', 'nama_lengkap', 'nim', 'fakultas_id', 'jenjang_id', 'prodi_id', 'pembimbing_1', 'nomor_handphone', 'jenis_kelamin'], 'required'],
            [['fakultas_id', 'jenjang_id', 'prodi_id', 'jumlah_revisi'], 'integer'],
            [['status', 'status_persetujuan'], 'string', 'max' => 50],
            [['email', 'judul_karya_ilmiah', 'nama_lengkap', 'nim', 'pembimbing_1', 'pembimbing_2', 'nomor_handphone', 'jenis_kelamin'], 'string', 'max' => 255],
            [['nomor_inventaris', 'password', 'nidn1', 'nidn2', 'nidn3', 'nidn4', 'contributor1_family', 'contributor1_given', 'contributor2_family', 'contributor2_given', 'contributor3_family', 'contributor3_given', 'contributor4_family', 'contributor4_given'], 'safe'],

            // aturan tambahan untuk status revisi
            ['status', 'in', 'range' => ['on process', 'revisi', 'ditolak', 'disetujui']],

            // upload file (overwrite)
            [['file_path'], 'string', 'max' => 255],
            [['fileUpload'], 'file', 'skipOnEmpty' => true, 'extensions' => 'pdf,doc,docx,jpg,png'],
        ];
    }

    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'email' => 'Email',
            'judul_karya_ilmiah' => 'Judul Karya Ilmiah',
            'nama_lengkap' => 'Nama Lengkap',
            'nim' => 'NIM',
            'fakultas_id' => 'Fakultas',
            'jenjang_id' => 'Jenjang',
            'prodi_id' => 'Program Studi',
            'pembimbing_1' => 'Pembimbing 1',
            'pembimbing_2' => 'Pembimbing 2',
            'contributor1_family' => 'Family Name (Contributor 1)',
            'contributor1_given'  => 'Given Name / Initials (Contributor 1)',
            'nidn1'               => 'NIDN/NIDK (Contributor 1)',
    
            'contributor2_family' => 'Family Name (Contributor 2)',
            'contributor2_given'  => 'Given Name / Initials (Contributor 2)',
            'nidn2'               => 'NIDN/NIDK (Contributor 2)',
    
            'contributor3_family' => 'Family Name (Contributor 3)',
            'contributor3_given'  => 'Given Name / Initials (Contributor 3)',
            'nidn3'               => 'NIDN/NIDK (Contributor 3)',
    
            'contributor4_family' => 'Family Name (Contributor 4)',
            'contributor4_given'  => 'Given Name / Initials (Contributor 4)',
            'nidn4'               => 'NIDN/NIDK (Contributor 4)',
            'nomor_handphone' => 'Nomor Handphone',
            'jenis_kelamin' => 'Jenis Kelamin',
            'status' => 'Status',
            'status_persetujuan' => 'Status Persetujuan',
            'jumlah_revisi' => 'Jumlah Revisi',
            'file_path' => 'File Upload',
        ];
    }

    // Relasi agar tetap menampilkan nama, bukan ID
    public function getFakultas()
    {
        return $this->hasOne(Fakultas::class, ['id' => 'fakultas_id']);
    }

    public function getJenjang()
    {
        return $this->hasOne(Jenjang::class, ['id' => 'jenjang_id']);
    }

    public function getProdi()
    {
        return $this->hasOne(Prodi::class, ['id' => 'prodi_id']);
    }

    // Sinkronisasi status_persetujuan dan hitung revisi
    public function beforeSave($insert)
    {
        if (parent::beforeSave($insert)) {
            // status_persetujuan otomatis sama dengan status
            $this->status_persetujuan = $this->status;

            // jika status revisi, tambahkan jumlah_revisi
            if ($this->status === 'revisi') {
                $this->jumlah_revisi = (int)$this->jumlah_revisi + 1;
            }

            return true;
        }
        return false;
    }
}
