<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "prodi".
 *
 * @property int $id
 * @property int $fakultas_id
 * @property int $jenjang_id
 * @property string $nama
 * @property string|null $kode_prodi
 *
 * @property Fakultas $fakultas
 * @property Jenjang $jenjang
 * @property Pendaftaran[] $pendaftarans
 */
class Prodi extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'prodi';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['kode_prodi'], 'default', 'value' => null],
            [['fakultas_id', 'jenjang_id', 'nama'], 'required'],
            [['fakultas_id', 'jenjang_id'], 'integer'],
            [['nama'], 'string', 'max' => 255],
            [['kode_prodi'], 'string', 'max' => 50],
            [['fakultas_id'], 'exist', 'skipOnError' => true, 'targetClass' => Fakultas::class, 'targetAttribute' => ['fakultas_id' => 'id']],
            [['jenjang_id'], 'exist', 'skipOnError' => true, 'targetClass' => Jenjang::class, 'targetAttribute' => ['jenjang_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'fakultas_id' => 'Fakultas',
            'jenjang_id' => 'Jenjang',
            'nama' => 'Nama Prodi',
            'kode_prodi' => 'Kode Prodi',
        ];
    }

    /**
     * Gets query for [[Fakultas]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getFakultas()
    {
        return $this->hasOne(Fakultas::class, ['id' => 'fakultas_id']);
    }
    
    public function getJenjang()
    {
        return $this->hasOne(Jenjang::class, ['id' => 'jenjang_id']);
    }

    /**
     * Gets query for [[Pendaftarans]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPendaftarans()
    {
        return $this->hasMany(Pendaftaran::class, ['prodi_id' => 'id']);
    }

    /**
     * Helper untuk dropdown fakultas
     */
    public static function getFakultasList()
    {
        return \yii\helpers\ArrayHelper::map(Fakultas::find()->all(), 'id', 'nama');
    }

    /**
     * Helper untuk dropdown jenjang
     */
    public static function getJenjangList()
    {
        return \yii\helpers\ArrayHelper::map(Jenjang::find()->all(), 'id', 'nama');
    }
}
