<?php

use yii\helpers\Html;
use yii\grid\GridView;

/** @var yii\web\View $this */
/** @var backend\models\PendaftaranSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Pendaftaran';
$this->params['breadcrumbs'][] = $this->title;

// Helper untuk ambil nama dari relasi secara aman
$relName = function($relModel, array $candidates = ['nama_fakultas','nama_jenjang','nama_prodi','nama','name','title']) {
    if (!$relModel) return null;
    foreach ($candidates as $attr) {
        if (method_exists($relModel, 'hasAttribute') && $relModel->hasAttribute($attr)) {
            $val = $relModel->getAttribute($attr);
            if ($val !== null && $val !== '') return $val;
        }
    }
    return $relModel->primaryKey ? (is_array($relModel->primaryKey) ? implode('-', $relModel->primaryKey) : $relModel->primaryKey) : null;
};

?>
<div class="pendaftaran-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Create Pendaftaran', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel'  => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
            'nama_lengkap',
            'nim',
            [
                'attribute' => 'fakultas_id',
                'label' => 'Fakultas',
                'value' => function($model) use ($relName) {
                    return $relName($model->fakultas);
                }
            ],
            [
                'attribute' => 'jenjang_id',
                'label' => 'Jenjang',
                'value' => function($model) use ($relName) {
                    return $relName($model->jenjang);
                }
            ],
            [
                'attribute' => 'prodi_id',
                'label' => 'Program Studi',
                'value' => function($model) use ($relName) {
                    return $relName($model->prodi);
                }
            ],
            'status',
            'status_persetujuan',
            'jumlah_revisi',
            [
                'attribute' => 'file_path',
                'format' => 'raw',
                'value' => function($model) {
                    return $model->file_path
                        ? Html::a('Download', Yii::getAlias('@web/uploadspersetujuan/' . $model->file_path), ['target' => '_blank'])
                        : '(Belum ada)';
                }
            ],

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>

</div>
