<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/** @var yii\web\View $this */
/** @var backend\models\Pendaftaran $model */

$this->title = $model->nama_lengkap;
$this->params['breadcrumbs'][] = ['label' => 'Pendaftaran', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);

// Helper untuk ambil nama relasi secara aman
$relName = function($relModel, array $candidates = ['nama_fakultas','nama_jenjang','nama_prodi','nama','name','title']) {
    if (!$relModel) return null;
    foreach ($candidates as $attr) {
        if (method_exists($relModel, 'hasAttribute') && $relModel->hasAttribute($attr)) {
            $val = $relModel->getAttribute($attr);
            if ($val !== null && $val !== '') return $val;
        }
    }
    return $relModel->primaryKey ? (is_array($relModel->primaryKey) ? implode('-', $relModel->primaryKey) : $relModel->primaryKey) : null;
};

?>
<div class="pendaftaran-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'email:email',
            'judul_karya_ilmiah',
            'nama_lengkap',
            'nim',
            [
                'attribute' => 'fakultas_id',
                'label' => 'Fakultas',
                'value' => $relName($model->fakultas),
            ],
            [
                'attribute' => 'jenjang_id',
                'label' => 'Jenjang',
                'value' => $relName($model->jenjang),
            ],
            [
                'attribute' => 'prodi_id',
                'label' => 'Program Studi',
                'value' => $relName($model->prodi),
            ],
            'pembimbing_1',
            'pembimbing_2',
            'contributor1_family',
        'contributor1_given',
        'nidn1',
        'contributor2_family',
        'contributor2_given',
        'nidn2',
        'contributor3_family',
        'contributor3_given',
        'nidn3',
        'contributor4_family',
        'contributor4_given',
        'nidn4',
            'nomor_handphone',
            'jenis_kelamin',
            'status',
            'status_persetujuan',
            'jumlah_revisi',
            [
                'attribute' => 'file_path',
                'format' => 'raw',
                'value' => $model->file_path
                    ? Html::a(
                        'Download File',
                        Yii::getAlias('@web/uploadspersetujuan/' . basename($model->file_path)),
                        ['target' => '_blank']
                    )
                    : '(Belum ada file)',
            ],
            
        ],
    ]) ?>

</div>
