<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use backend\models\Fakultas;
use backend\models\Jenjang;

?>

<div class="prodi-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'fakultas_id')->dropDownList(
    ArrayHelper::map(Fakultas::find()->all(), 'id', 'nama'),
    ['prompt' => 'Pilih Fakultas', 'id' => 'fakultas-id']
    ) ?>

    <?= $form->field($model, 'jenjang_id')->dropDownList(
        $model->isNewRecord ? [] : ArrayHelper::map(Jenjang::find()->where(['fakultas_id' => $model->fakultas_id])->all(), 'id', 'nama'),
        ['prompt' => 'Pilih Jenjang', 'id' => 'jenjang-id']
    ) ?>


    <?= $form->field($model, 'nama')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'kode_prodi')->textInput(['maxlength' => true]) ?>

    <div class="form-group">
        <?= Html::submitButton('Simpan', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>

<?php
$script = <<< JS
$('#fakultas-id').on('change', function () {
    var fakultasID = $(this).val();
    if (fakultasID) {
        $.ajax({
            url: 'http://backend.local/index.php?r=prodi/get-jenjang&fakultas_id=' + fakultasID,
            type: 'GET',
            success: function (data) {
                var options = '<option value="">Pilih Jenjang</option>';
                $.each(data, function (key, value) {
                    options += '<option value="' + key + '">' + value + '</option>';
                });
                $('#jenjang-id').html(options);
            }
        });
    } else {
        $('#jenjang-id').html('<option value="">Pilih Jenjang</option>');
    }
});
JS;

$this->registerJs($script);
?>
